import { Header } from "@/components/header"
import { HeroSection } from "@/components/hero-section"
import { ThreeStepsSection } from "@/components/three-steps-section"
import { BatteryFinder } from "@/components/battery-finder"
import { ProductCatalog } from "@/components/product-catalog"
import { BrandsSection } from "@/components/brands-section"
import { AboutSection } from "@/components/about-section"
import { ContactSection } from "@/components/contact-section"
import { Footer } from "@/components/footer"
import { WhatsAppFloat } from "@/components/whatsapp-float"
import { CartProvider } from "@/components/cart-context"

export default function Home() {
  return (
    <CartProvider>
      <main className="min-h-screen">
        <Header />
        <HeroSection />
        <ThreeStepsSection />
        <BatteryFinder />
        <ProductCatalog />
        <BrandsSection />
        <AboutSection />
        <ContactSection />
        <Footer />
        <WhatsAppFloat />
      </main>
    </CartProvider>
  )
}
