<?php
include 'header.php';
include '../db.php';

// Cargar ajustes actuales (id fijo = 1)
$aj = $conn->query("SELECT * FROM ajustes WHERE id=1")->fetch_assoc();
$nombre_actual = $aj['nombre_sitio'] ?? 'Mundo Baterías';
$logo_actual   = $aj['logo_path']     ?? null;

$errores = [];
$ok      = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre_sitio  = trim($_POST['nombre_sitio'] ?? '');
    $eliminar_logo = isset($_POST['eliminar_logo']) ? 1 : 0;

    // --- Validación nombre ---
    if ($nombre_sitio === '') {
        $errores[] = 'El nombre del sitio no puede estar vacío.';
    }

    // --- Manejo de logo ---
    $nuevo_logo_rel = $logo_actual; // por defecto conservo el actual

    // Si pidieron eliminar el logo
    if ($eliminar_logo && $logo_actual) {
        $abs = __DIR__ . '/' . $logo_actual; // p.e. admin/img/logo_xxx.png
        if (is_file($abs)) @unlink($abs);
        $nuevo_logo_rel = null;
    }

    // Si subieron un archivo
    if (!empty($_FILES['logo']['name']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
        $tmp = $_FILES['logo']['tmp_name'];
        $origName = $_FILES['logo']['name'];

        // Carpeta destino (está en admin/img)
        $destDir = __DIR__ . '/img';
        if (!is_dir($destDir)) @mkdir($destDir, 0775, true);

        // Detección simple de tipo
        $ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
        $permitidas_ext = ['png','jpg','jpeg','gif','webp','svg'];

        if (!in_array($ext, $permitidas_ext, true)) {
            $errores[] = 'Formato de imagen no permitido. Usa PNG, JPG, GIF, WEBP o SVG.';
        } else {
            $es_svg = ($ext === 'svg');

            // Para imágenes raster (no SVG) verificamos que realmente sea imagen
            if (!$es_svg) {
                $gi = @getimagesize($tmp);
                if ($gi === false) {
                    $errores[] = 'El archivo subido no parece ser una imagen válida.';
                }
            }

            if (!$errores) {
                // Nombre final
                $filename = 'logo_' . time() . '.' . $ext;
                $destAbs  = $destDir . '/' . $filename;
                $relPath  = 'img/' . $filename; // ruta relativa para guardar en BD

                if (@move_uploaded_file($tmp, $destAbs)) {
                    // Borrar logo anterior si existía
                    if ($logo_actual) {
                        $old = __DIR__ . '/' . $logo_actual;
                        if (is_file($old)) @unlink($old);
                    }
                    $nuevo_logo_rel = $relPath;
                } else {
                    $errores[] = 'No se pudo mover el archivo subido. Revisa permisos de la carpeta admin/img.';
                }
            }
        }
    }

    if (!$errores) {
        // Upsert simple (id=1)
        if ($conn->query("SELECT 1 FROM ajustes WHERE id=1")->num_rows) {
            $stmt = $conn->prepare("UPDATE ajustes SET nombre_sitio=?, logo_path=?, updated_at=NOW() WHERE id=1");
            $stmt->bind_param("ss", $nombre_sitio, $nuevo_logo_rel);
        } else {
            $stmt = $conn->prepare("INSERT INTO ajustes (id, nombre_sitio, logo_path, updated_at) VALUES (1, ?, ?, NOW())");
            $stmt->bind_param("ss", $nombre_sitio, $nuevo_logo_rel);
        }
        $stmt->execute();
        $ok = 'Ajustes guardados correctamente.';

        // Refrescar variables en memoria
        $nombre_actual = $nombre_sitio;
        $logo_actual   = $nuevo_logo_rel;
    }
}
?>

<div class="container my-4 my-lg-5">
  <div class="row justify-content-center">
    <div class="col-12 col-lg-7">
      <h1 class="mb-4"><i class="fa fa-gear"></i> Ajustes del sitio</h1>

      <?php if ($ok): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
          <?= htmlspecialchars($ok) ?>
          <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
      <?php endif; ?>

      <?php if ($errores): ?>
        <div class="alert alert-danger">
          <ul class="mb-0">
            <?php foreach ($errores as $e): ?>
              <li><?= htmlspecialchars($e) ?></li>
            <?php endforeach; ?>
          </ul>
        </div>
      <?php endif; ?>

      <div class="card shadow border-0">
        <div class="card-body p-4">
          <form method="POST" enctype="multipart/form-data" class="row g-3">

            <div class="col-12">
              <label class="form-label">Nombre del sitio</label>
              <input type="text" name="nombre_sitio" class="form-control"
                     value="<?= htmlspecialchars($nombre_actual) ?>" required>
            </div>

            <div class="col-12 col-md-6">
              <label class="form-label">Logo actual</label>
              <div class="border rounded p-3 text-center bg-light">
                <?php if ($logo_actual): ?>
                  <img src="<?= htmlspecialchars($logo_actual) ?>" alt="logo" style="height:90px; object-fit:contain;">
                <?php else: ?>
                  <!-- Sin logo: icono grande por defecto -->
                  <div class="text-muted">
                    <i class="fa-solid fa-car-battery" style="font-size:72px;"></i>
                    <div class="small">Sin logo</div>
                  </div>
                <?php endif; ?>
              </div>
              <?php if ($logo_actual): ?>
                <div class="form-check mt-2">
                  <input class="form-check-input" type="checkbox" value="1" id="chkEliminar" name="eliminar_logo">
                  <label class="form-check-label" for="chkEliminar">
                    Quitar logo actual
                  </label>
                </div>
              <?php endif; ?>
            </div>

            <div class="col-12 col-md-6">
              <label class="form-label">Subir nuevo logo (PNG/JPG/GIF/WEBP/SVG)</label>
              <input type="file" name="logo" class="form-control">
              <small class="text-muted">Tamaño recomendado aproximado: 200×60px (ancho x alto).</small>
            </div>

            <div class="col-12 text-end">
              <a href="index.php" class="btn btn-outline-secondary">
                <i class="fa fa-arrow-left"></i> Volver
              </a>
              <button type="submit" class="btn btn-primary">
                <i class="fa fa-save"></i> Guardar cambios
              </button>
            </div>

          </form>
        </div>
      </div>

    </div>
  </div>
</div>

<?php include 'footer.php'; ?>

