<?php 
include 'header.php'; 
include '../db.php';

// Insertar nueva categoría
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'];
    $sql = "INSERT INTO categorias (nombre) VALUES (?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $nombre);
    $stmt->execute();
    echo "<div class='alert alert-success'>Categoría agregada correctamente ✅</div>";
}

// Obtener categorías
$result = $conn->query("SELECT * FROM categorias");
?>

<h1 class="mb-4">Catalogos</h1>

<!-- Formulario agregar categoría -->
<div class="card shadow mb-4">
  <div class="card-body">
    <form method="POST" class="row g-3">
      <div class="col-md-8">
        <input type="text" name="nombre" class="form-control" placeholder="Nombre de categoría" required>
      </div>
      <div class="col-md-4">
        <button type="submit" class="btn btn-success w-100">
          <i class="fa fa-plus"></i> Agregar
        </button>
      </div>
    </form>
  </div>
</div>

<!-- Tabla de categorías -->
<div class="card shadow">
  <div class="card-body">
    <table class="table table-hover table-bordered">
      <thead class="table-dark">
        <tr>
          <th>ID</th>
          <th>Nombre</th>
          <th>Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php while($row = $result->fetch_assoc()): ?>
        <tr>
          <td><?= $row['id'] ?></td>
          <td><?= $row['nombre'] ?></td>
          <td>
            <a href="eliminar_categoria.php?id=<?= $row['id'] ?>" 
               class="btn btn-sm btn-danger"
               onclick="return confirm('¿Seguro que deseas eliminar esta categoría?')">
              <i class="fa fa-trash"></i> Eliminar
            </a>
          </td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include 'footer.php'; ?>
