<?php
include 'header.php';
include '../db.php';

// 1) validar id y traer la página
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) { header('Location: paginas.php'); exit; }

$stmt = $conn->prepare("SELECT id, slug, titulo, contenido FROM paginas WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$pagina = $stmt->get_result()->fetch_assoc();
if (!$pagina) { header('Location: paginas.php'); exit; }

// 2) actualizar
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $slug      = trim($_POST['slug'] ?? '');
  $titulo    = trim($_POST['titulo'] ?? '');
  $contenido = $_POST['contenido'] ?? '';

  $up = $conn->prepare("UPDATE paginas SET slug=?, titulo=?, contenido=? WHERE id=?");
  $up->bind_param("sssi", $slug, $titulo, $contenido, $id);
  $up->execute();

  header("Location: paginas.php");
  exit;
}
?>

<div class="container my-4 my-lg-5">
  <div class="row justify-content-center">
    <div class="col-12 col-lg-9">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h4 mb-0"><i class="fa fa-file-pen"></i> Editar página</h1>
        <a href="paginas.php" class="btn btn-outline-secondary">
          <i class="fa fa-arrow-left"></i> Volver
        </a>
      </div>

      <div class="card shadow-sm border-0">
        <div class="card-body p-4">
          <form method="POST" class="row g-3">
            <div class="col-12 col-md-4">
              <label class="form-label">Slug</label>
              <input type="text" name="slug" class="form-control"
                     value="<?= htmlspecialchars($pagina['slug']) ?>" required>
              <small class="text-muted">Ej: quienes-somos, contacto</small>
            </div>
            <div class="col-12 col-md-8">
              <label class="form-label">Titulo</label>
              <input type="text" name="titulo" class="form-control"
                     value="<?= htmlspecialchars($pagina['titulo']) ?>" required>
            </div>

            <div class="col-12">
              <label class="form-label">Contenido</label>
              <textarea id="editor" name="contenido" rows="12" class="form-control">
<?= htmlspecialchars($pagina['contenido']) ?>
              </textarea>
            </div>

            <div class="col-12 text-end">
              <a href="paginas.php" class="btn btn-outline-secondary">
                <i class="fa fa-arrow-left"></i> Cancelar
              </a>
              <button class="btn btn-success">
                <i class="fa fa-save"></i> Guardar cambios
              </button>
            </div>
          </form>
        </div>
      </div>

    </div>
  </div>
</div>

<?php include 'footer.php'; ?>

<!-- CKEditor 5 (Classic) por CDN -->
<script src="https://cdn.ckeditor.com/ckeditor5/41.4.2/classic/ckeditor.js"></script>
<script>
  ClassicEditor
    .create(document.querySelector('#editor'), {
      toolbar: [
        'heading','|','bold','italic','underline','link','bulletedList','numberedList',
        '|','blockQuote','insertTable','undo','redo','removeFormat'
      ],
      table: { contentToolbar: ['tableColumn', 'tableRow', 'mergeTableCells'] },
      language: 'es'
    })
    .catch(err => console.error(err));
</script>
