<?php
include 'header.php';
include '../db.php';

/* -----------------------
   Validar ID y cargar
------------------------ */
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  header("Location: productos.php");
  exit;
}

$stmt = $conn->prepare("SELECT * FROM productos WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$producto = $stmt->get_result()->fetch_assoc();
if (!$producto) {
  header("Location: productos.php");
  exit;
}

/* -----------------------
   Actualizar (POST)
------------------------ */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $categoria_id       = (int)($_POST['categoria_id'] ?? 0);
  $nombre             = trim($_POST['nombre'] ?? '');
  $descripcion        = trim($_POST['descripcion'] ?? '');
  $info_adicional     = trim($_POST['info_adicional'] ?? '');
  $precio_sin_bateria = ($_POST['precio_sin_bateria'] !== '' ? (float)$_POST['precio_sin_bateria'] : 0);
  $precio_con_bateria = ($_POST['precio_con_bateria'] !== '' ? (float)$_POST['precio_con_bateria'] : 0);
  $capacidad          = trim($_POST['capacidad'] ?? '');
  $cca                = trim($_POST['cca'] ?? '');

  // Imagen (si suben una nueva, reemplazamos la anterior)
  $imagen = $producto['imagen'] ?? '';
  if (!empty($_FILES['imagen']['name'])) {
    $destDir = "../uploads/";
    if (!is_dir($destDir)) { @mkdir($destDir, 0775, true); }
    $base   = preg_replace('/[^A-Za-z0-9._-]/', '_', $_FILES['imagen']['name']);
    $nuevo  = time() . '_' . $base;
    if (move_uploaded_file($_FILES['imagen']['tmp_name'], $destDir . $nuevo)) {
      // borrar anterior si existe
      if ($imagen && file_exists($destDir.$imagen)) { @unlink($destDir.$imagen); }
      $imagen = $nuevo;
    }
  }

  $sql = "UPDATE productos
          SET categoria_id=?, nombre=?, descripcion=?, info_adicional=?,
              precio_sin_bateria=?, precio_con_bateria=?, capacidad=?, cca=?, imagen=?
          WHERE id=?";
  $upd = $conn->prepare($sql);
  $upd->bind_param(
    "isssddsssi",
    $categoria_id, $nombre, $descripcion, $info_adicional,
    $precio_sin_bateria, $precio_con_bateria, $capacidad, $cca, $imagen, $id
  );
  $upd->execute();

  header("Location: productos.php");
  exit;
}

/* -----------------------
   Cargar categorías
------------------------ */
$cats = $conn->query("SELECT id, nombre FROM categorias ORDER BY nombre ASC");
$categorias = [];
while ($c = $cats->fetch_assoc()) { $categorias[] = $c; }
?>

<div class="container my-4 my-lg-5">
  <div class="row justify-content-center">
    <div class="col-12 col-lg-8 col-xxl-7">

      <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h4 mb-0"><i class="fa fa-pen-to-square"></i> Editar producto</h1>
        <a href="productos.php" class="btn btn-outline-secondary">
          <i class="fa fa-arrow-left"></i> Volver
        </a>
      </div>

      <div class="card shadow border-0">
        <div class="card-body p-4">
          <form method="POST" enctype="multipart/form-data" class="row g-3">

            <!-- Categoria y Nombre -->
            <div class="col-12 col-md-6">
              <label class="form-label">Categoria</label>
              <select name="categoria_id" class="form-select" required>
                <?php foreach($categorias as $c): ?>
                  <option value="<?= $c['id'] ?>" <?= ($c['id']==$producto['categoria_id']?'selected':'') ?>>
                    <?= htmlspecialchars($c['nombre']) ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">Nombre</label>
              <input type="text" name="nombre" value="<?= htmlspecialchars($producto['nombre']) ?>"
                     class="form-control" required>
            </div>

            <!-- Descripcion -->
            <div class="col-12">
              <label class="form-label">Descripcion</label>
              <textarea name="descripcion" class="form-control" rows="3"
                        placeholder="Caracteristicas, uso, etc."><?= htmlspecialchars($producto['descripcion']) ?></textarea>
            </div>

            <!-- Info adicional -->
            <div class="col-12">
              <label class="form-label">Informacion adicional</label>
              <textarea name="info_adicional" class="form-control" rows="3"
                        placeholder="Garantia, notas, recomendaciones..."><?= htmlspecialchars($producto['info_adicional']) ?></textarea>
            </div>

            <!-- Precios -->
            <div class="col-12 col-md-6">
              <label class="form-label">Precio SIN bateria</label>
              <div class="input-group">
                <span class="input-group-text">S/</span>
                <input type="number" step="0.01" name="precio_sin_bateria"
                       value="<?= htmlspecialchars($producto['precio_sin_bateria']) ?>"
                       class="form-control" placeholder="Ej: 250.00">
              </div>
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">Precio CON bateria</label>
              <div class="input-group">
                <span class="input-group-text">S/</span>
                <input type="number" step="0.01" name="precio_con_bateria"
                       value="<?= htmlspecialchars($producto['precio_con_bateria']) ?>"
                       class="form-control" placeholder="Ej: 350.00">
              </div>
            </div>

            <!-- Capacidad y CCA -->
            <div class="col-12 col-md-6">
              <label class="form-label">Capacidad (Ah)</label>
              <input type="text" name="capacidad"
                     value="<?= htmlspecialchars($producto['capacidad']) ?>"
                     class="form-control" placeholder="Ej: 45Ah">
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">CCA</label>
              <input type="text" name="cca"
                     value="<?= htmlspecialchars($producto['cca']) ?>"
                     class="form-control" placeholder="Ej: 430CCA">
            </div>

            <!-- Imagen -->
            <div class="col-12 col-md-6">
              <label class="form-label d-block">Imagen actual</label>
              <?php if (!empty($producto['imagen'])): ?>
                <img src="../uploads/<?= htmlspecialchars($producto['imagen']) ?>"
                     alt="img" style="height:90px; object-fit:cover; border-radius:8px; border:1px solid #e9ecef;">
              <?php else: ?>
                <span class="text-muted">Sin imagen</span>
              <?php endif; ?>
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">Subir nueva imagen</label>
              <input type="file" name="imagen" class="form-control" accept="image/*">
              <small class="text-muted">Se reemplazará la imagen actual si subes una nueva.</small>
            </div>

            <!-- Acciones -->
            <div class="col-12 text-end">
              <a href="productos.php" class="btn btn-outline-secondary">
                <i class="fa fa-arrow-left"></i> Volver
              </a>
              <button type="submit" class="btn btn-success">
                <i class="fa fa-save"></i> Guardar cambios
              </button>
            </div>

          </form>
        </div>
      </div>

    </div>
  </div>
</div>

<?php include 'footer.php'; ?>
