<?php
// Iniciar sesión solo si no está ya activa
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['admin']) && basename($_SERVER['PHP_SELF']) !== "login.php") {
    header("Location: login.php");
    exit;
}

/* --------- Branding (nombre y logo) ---------- */
$BRAND = ['nombre' => 'Mundo Baterías', 'logo' => null];

// Traemos conexión si no existe
if (!isset($conn)) { @include_once __DIR__ . '/../db.php'; }

if (isset($conn)) {
    $res = $conn->query("SELECT nombre_sitio, logo_path FROM ajustes WHERE id=1 LIMIT 1");
    if ($res && $row = $res->fetch_assoc()) {
        if (!empty($row['nombre_sitio'])) $BRAND['nombre'] = $row['nombre_sitio'];
        if (!empty($row['logo_path']))     $BRAND['logo']   = $row['logo_path']; // p.ej. "img/logo_123.png" o "uploads/logo.png"
    }
}

/* Ruta visible del logo según lo guardado en ajustes */
$brandLogoSrc = null;
if (!empty($BRAND['logo'])) {
    if (preg_match('#^img/#', $BRAND['logo'])) {
        $brandLogoSrc = $BRAND['logo'];                 // dentro de /backend/admin
    } elseif (preg_match('#^uploads/#', $BRAND['logo'])) {
        $brandLogoSrc = '../' . $BRAND['logo'];         // ../uploads/...
    } else {
        $brandLogoSrc = 'img/' . $BRAND['logo'];        // fallback
    }
}

/* URL del frontend (ajústala si tu instalación lo requiere) */
$FRONT_URL = '/frontend/index.php';
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Panel Admin - <?= htmlspecialchars($BRAND['nombre']) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">

  <style>
    body{background:#f5f6fa;font-family:'Segoe UI',Tahoma,Geneva,Verdana,sans-serif;overflow-x:hidden}
    .sidebar{height:100vh;width:240px;position:fixed;top:0;left:0;background:linear-gradient(180deg,#212529,#343a40);color:#fff;padding-top:70px;z-index:1040}
    .sidebar a{color:#adb5bd;display:block;padding:12px 20px;margin:4px 10px;border-radius:6px;text-decoration:none;transition:all .2s}
    .sidebar a:hover,.sidebar a.active{background:#495057;color:#fff;transform:translateX(5px)}

    .brand-wrap{ text-align:center; margin: 0 14px 28px; }
    .brand-logo{
      width: 100px; height: 100px; object-fit: cover;
      border-radius: 22px; background: rgba(255,255,255,.05);
      border: 1px solid rgba(255,255,255,.15);
      display: inline-block;
    }
    .brand-fallback{
      width: 100px; height: 100px; border-radius: 22px;
      background: rgba(255,255,255,.06);
      border: 1px solid rgba(255,255,255,.15);
      display: grid; place-items:center;
      margin: 0 auto;
    }
    .brand-fallback i{ font-size:64px; color:#ffc107; filter:drop-shadow(0 2px 2px rgba(0,0,0,.25)) }
    .brand-name{ font-weight:900; font-size:18px; margin-top:8px; letter-spacing:.2px }

    .navbar{position:fixed;top:0;left:240px;right:0;z-index:1000;background:#fff;border-bottom:1px solid #dee2e6;box-shadow:0 2px 6px rgba(0,0,0,.1)}
    .content{margin-left:240px;padding:90px 25px 30px 25px;min-height:calc(100vh - 70px)}
    footer{margin-left:240px;background:#212529;color:#adb5bd;padding:15px 0;text-align:center}

    @media (max-width: 767.98px){
      .content,.navbar,footer{margin-left:0!important}
      .sidebar{position:fixed;transform:translateX(-100%);transition:transform .3s ease}
      .sidebar.show{transform:translateX(0)}
      .navbar{left:0}
    }
  </style>
</head>
<body>

<!-- Sidebar -->
<div class="sidebar" id="sidebar">
  <div class="brand-wrap">
    <?php if (!empty($brandLogoSrc)): ?>
      <img src="<?= htmlspecialchars($brandLogoSrc) ?>" class="brand-logo" alt="Logo">
    <?php else: ?>
      <div class="brand-fallback"><i class="fa-solid fa-car-battery"></i></div>
    <?php endif; ?>
    <div class="brand-name"><?= htmlspecialchars($BRAND['nombre']) ?></div>
  </div>

  <a href="index.php" class="<?= basename($_SERVER['PHP_SELF'])=='index.php'?'active':'' ?>"><i class="fa fa-home me-2"></i> Dashboard</a>
  <a href="productos.php" class="<?= basename($_SERVER['PHP_SELF'])=='productos.php'?'active':'' ?>"><i class="fa fa-box me-2"></i> Productos</a>
  <a href="categorias.php" class="<?= basename($_SERVER['PHP_SELF'])=='categorias.php'?'active':'' ?>"><i class="fa fa-tags me-2"></i> Catalogos</a>
  <a href="marcas.php" class="<?= basename($_SERVER['PHP_SELF'])=='marcas.php'?'active':'' ?>"><i class="fa fa-flag me-2"></i> Marcas</a>
  <a href="modelos.php" class="<?= basename($_SERVER['PHP_SELF'])=='modelos.php'?'active':'' ?>"><i class="fa fa-car-side me-2"></i> Modelos</a>
  <a href="paginas.php" class="<?= basename($_SERVER['PHP_SELF'])=='paginas.php'?'active':'' ?>"><i class="fa fa-file-alt me-2"></i> Páginas</a>
  <a href="ajustes.php" class="<?= basename($_SERVER['PHP_SELF'])=='ajustes.php'?'active':'' ?>"><i class="fa fa-gear me-2"></i> Ajustes</a>
  <a href="logout.php" class="text-danger"><i class="fa fa-sign-out-alt me-2"></i> Salir</a>
</div>

<!-- Navbar -->
<nav class="navbar navbar-light px-3">
  <button class="btn btn-outline-dark d-md-none me-2" id="toggleSidebar">
    <i class="fa fa-bars"></i>
  </button>

  <div class="d-flex align-items-center gap-3">
    <span class="navbar-text fw-bold text-dark">⚡ Panel de Administración</span>

    <!-- Botón "Ir al sitio" -->
    <a href="<?= htmlspecialchars($FRONT_URL) ?>"
       class="btn btn-sm btn-outline-primary d-none d-md-inline-flex"
       target="_blank" rel="noopener">
      Ir al sitio <i class="fa-solid fa-arrow-up-right-from-square ms-1"></i>
    </a>
  </div>
</nav>

<!-- Contenido -->
<div class="content">
<script>
  document.getElementById('toggleSidebar')?.addEventListener('click', ()=>{
    document.getElementById('sidebar')?.classList.toggle('show');
  });
</script>
