<?php
include 'header.php';
include '../db.php';

/* ---------- KPIs ---------- */
function safe_count($conn, $table) {
  $q = $conn->query("SELECT COUNT(*) AS c FROM {$table}");
  return $q ? (int)$q->fetch_assoc()['c'] : 0;
}

$total_productos  = safe_count($conn, 'productos');
$total_categorias = safe_count($conn, 'categorias');
$total_marcas     = safe_count($conn, 'marcas');
$total_modelos    = safe_count($conn, 'modelos');

/* ---------- Chart: productos por categoria ---------- */
$cat_labels = []; $cat_data = [];
$sqlCat = "
  SELECT c.nombre AS n, COUNT(p.id) AS t
  FROM categorias c
  LEFT JOIN productos p ON p.categoria_id = c.id
  GROUP BY c.id
  ORDER BY c.nombre
";
if ($res = $conn->query($sqlCat)) {
  while ($r = $res->fetch_assoc()) { $cat_labels[] = $r['n']; $cat_data[] = (int)$r['t']; }
}

/* ---------- Chart: productos por marca (sin duplicar) ---------- */
$mk_labels = []; $mk_data = [];
$sqlMk = "
  SELECT mk.nombre AS n, COUNT(DISTINCT pm.producto_id) AS t
  FROM marcas mk
  LEFT JOIN modelos m ON m.marca_id = mk.id
  LEFT JOIN producto_modelo pm ON pm.modelo_id = m.id
  GROUP BY mk.id
  ORDER BY mk.nombre
";
if ($res2 = $conn->query($sqlMk)) {
  while ($r = $res2->fetch_assoc()) { $mk_labels[] = $r['n']; $mk_data[] = (int)$r['t']; }
}

/* ---------- Ultimos productos ---------- */
$ultimos = $conn->query("
  SELECT id, nombre, precio_sin_bateria, precio_con_bateria
  FROM productos ORDER BY id DESC LIMIT 8
");
?>
<style>
  /* Título general más contundente */
  h1 {
    font-weight: 800;
    letter-spacing: .3px;
  }

  /* Tarjetas KPI: contenedor */
  .kpi{
    border:0;
    border-radius:14px;
    box-shadow:0 8px 20px rgba(0,0,0,.10);
    overflow:hidden;
  }
  .kpi .card-body{
    padding: 18px 20px;
  }

  /* Texto de KPI SIEMPRE blanco y con sombra sutil para contraste */
  .kpi .num,
  .kpi .lbl,
  .kpi .icon{
    color:#fff !important;
    text-shadow: 0 1px 2px rgba(0,0,0,.25);
  }

  /* Número grande y grueso */
  .kpi .num{
    font-size: 34px;
    font-weight: 800;
    line-height: 1;
    margin-bottom: 2px;
  }

  /* Etiqueta visible */
  .kpi .lbl{
    font-size: 15px;
    font-weight: 700;
    opacity: .98;
  }

  /* Icono un poco más grande */
  .kpi .icon{
    font-size: 30px;
    opacity: .95;
  }

  /* Tarjetas de atajos con texto blanco legible */
  .card.text-bg-primary .card-title,
  .card.text-bg-primary .card-text,
  .card.text-bg-success .card-title,
  .card.text-bg-success .card-text,
  .card.text-bg-warning .card-title,
  .card.text-bg-warning .card-text{
    color:#fff !important;
    text-shadow: 0 1px 2px rgba(0,0,0,.2);
  }

  /* Cabeceras de tarjetas de gráficos */
  .card-header strong{
    font-weight: 800;
  }

  /* Tabla de últimos productos: tipografía clara */
  .table th{
    font-weight: 800;
  }
</style>

<div class="container-fluid px-2 px-lg-3">
  <h1 class="mb-4">Panel admin</h1>

  <!-- KPIs -->
  <div class="row g-3 mb-3">
    <div class="col-12 col-sm-6 col-xl-3">
      <div class="card kpi text-bg-primary">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="num"><?= $total_productos ?></div>
            <div class="lbl">Productos</div>
          </div>
          <i class="fa fa-box icon"></i>
        </div>
      </div>
    </div>
    <div class="col-12 col-sm-6 col-xl-3">
      <div class="card kpi text-bg-success">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="num"><?= $total_categorias ?></div>
            <div class="lbl">Catalogos</div>
          </div>
          <i class="fa fa-tags icon"></i>
        </div>
      </div>
    </div>
    <div class="col-12 col-sm-6 col-xl-3">
      <div class="card kpi text-bg-info">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="num"><?= $total_marcas ?></div>
            <div class="lbl">Marcas</div>
          </div>
          <i class="fa fa-flag icon"></i>
        </div>
      </div>
    </div>
    <div class="col-12 col-sm-6 col-xl-3">
      <div class="card kpi text-bg-warning">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="num"><?= $total_modelos ?></div>
            <div class="lbl">Modelos</div>
          </div>
          <i class="fa fa-car-side icon"></i>
        </div>
      </div>
    </div>
  </div>

  <!-- Graficos -->
  <div class="row g-3">
    <div class="col-12 col-lg-7">
      <div class="card shadow-sm h-100">
        <div class="card-header bg-white"><strong>Productos por marca</strong></div>
        <div class="card-body">
          <canvas id="chartMarcas" height="150"></canvas>
        </div>
      </div>
    </div>
    <div class="col-12 col-lg-5">
      <div class="card shadow-sm h-100">
        <div class="card-header bg-white"><strong>Productos por categoria</strong></div>
        <div class="card-body">
          <canvas id="chartCategorias" height="150"></canvas>
        </div>
      </div>
    </div>
  </div>

  <!-- Atajos -->
  <div class="row g-3 mt-3">
    <div class="col-12 col-md-4">
      <div class="card text-bg-primary shadow h-100">
        <div class="card-body">
          <h5 class="card-title"><i class="fa fa-box"></i> Productos</h5>
          <p class="card-text">Gestiona todos los productos.</p>
          <a href="productos.php" class="btn btn-light btn-sm">Ver mas</a>
        </div>
      </div>
    </div>
    <div class="col-12 col-md-4">
      <div class="card text-bg-success shadow h-100">
        <div class="card-body">
          <h5 class="card-title"><i class="fa fa-tags"></i> Catalogos</h5>
          <p class="card-text">Administra catalogos.</p>
          <a href="categorias.php" class="btn btn-light btn-sm">Ver mas</a>
        </div>
      </div>
    </div>
    <div class="col-12 col-md-4">
      <div class="card text-bg-warning shadow h-100">
        <div class="card-body">
          <h5 class="card-title"><i class="fa fa-file-alt"></i> Paginas</h5>
          <p class="card-text">Edita secciones estaticas.</p>
          <a href="paginas.php" class="btn btn-dark btn-sm">Ver mas</a>
        </div>
      </div>
    </div>
  </div>

  <!-- Ultimos productos -->
  <div class="card shadow-sm mt-3">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
      <strong>Ultimos productos</strong>
      <a href="productos.php" class="btn btn-sm btn-outline-secondary">Ver todo</a>
    </div>
    <div class="card-body table-responsive">
      <table class="table align-middle mb-0">
        <thead>
          <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th class="text-end">Precio sin bateria</th>
            <th class="text-end">Precio con bateria</th>
          </tr>
        </thead>
        <tbody>
        <?php if ($ultimos && $ultimos->num_rows): ?>
          <?php while($p = $ultimos->fetch_assoc()): ?>
            <tr>
              <td><?= $p['id'] ?></td>
              <td><?= htmlspecialchars($p['nombre']) ?></td>
              <td class="text-end">S/ <?= number_format((float)$p['precio_sin_bateria'], 2) ?></td>
              <td class="text-end">S/ <?= number_format((float)$p['precio_con_bateria'], 2) ?></td>
            </tr>
          <?php endwhile; ?>
        <?php else: ?>
          <tr><td colspan="4" class="text-center text-muted">Sin registros</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
  const catLabels = <?= json_encode($cat_labels, JSON_UNESCAPED_UNICODE) ?>;
  const catData   = <?= json_encode($cat_data) ?>;
  const mkLabels  = <?= json_encode($mk_labels,  JSON_UNESCAPED_UNICODE) ?>;
  const mkData    = <?= json_encode($mk_data) ?>;

  // Bar: productos por marca
  new Chart(document.getElementById('chartMarcas'), {
    type: 'bar',
    data: {
      labels: mkLabels,
      datasets: [{
        label: 'Productos',
        data: mkData,
        borderWidth: 1
      }]
    },
    options: {
      maintainAspectRatio: false,
      scales: { y: { beginAtZero: true, ticks: { precision:0 } } },
      plugins: { legend: { display: false } }
    }
  });

  // Doughnut: productos por categoria
  new Chart(document.getElementById('chartCategorias'), {
    type: 'doughnut',
    data: {
      labels: catLabels,
      datasets: [{
        data: catData
      }]
    },
    options: {
      maintainAspectRatio: false,
      plugins: { legend: { position: 'bottom' } },
      cutout: '60%'
    }
  });
</script>

<?php include 'footer.php'; ?>

