<?php
include 'header.php';
include '../db.php';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $nombre = trim($_POST['nombre'] ?? '');
  if ($nombre !== '') {
    $stmt = $conn->prepare("INSERT INTO marcas(nombre) VALUES (?)");
    $stmt->bind_param("s", $nombre);
    $stmt->execute();
  }
  header("Location: marcas.php"); exit;
}

if (isset($_GET['del'])) {
  $id = (int)$_GET['del'];
  $conn->query("DELETE FROM marcas WHERE id=".$id);
  header("Location: marcas.php"); exit;
}

$res = $conn->query("SELECT * FROM marcas ORDER BY nombre ASC");
?>
<div class="container-fluid px-2 px-lg-3">
  <h1 class="mb-4"><i class="fa fa-flag"></i> Marcas</h1>

  <div class="card shadow-sm mb-3">
    <div class="card-body">
      <form method="POST" class="row g-2">
        <div class="col-12 col-md-6">
          <input class="form-control" name="nombre" placeholder="Nueva marca (p.ej. Toyota)" required>
        </div>
        <div class="col-12 col-md-3">
          <button class="btn btn-success w-100"><i class="fa fa-plus"></i> Agregar</button>
        </div>
      </form>
    </div>
  </div>

  <div class="card shadow-sm">
    <div class="card-body table-responsive">
      <table class="table align-middle">
        <thead><tr><th>ID</th><th>Nombre</th><th class="text-end">Acciones</th></tr></thead>
        <tbody>
        <?php while($r=$res->fetch_assoc()): ?>
          <tr>
            <td><?= $r['id'] ?></td>
            <td><?= htmlspecialchars($r['nombre']) ?></td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-danger" href="?del=<?= $r['id'] ?>" onclick="return confirm('¿Eliminar marca? Se borrarán sus modelos.');"><i class="fa fa-trash"></i></a>
            </td>
          </tr>
        <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php include 'footer.php'; ?>
