<?php
include 'header.php';
include '../db.php';

/* ----- opciones de anio ----- */
$maxY = (int)date('Y') + 1;
$minY = 1980;
function year_options($minY, $maxY) {
  $out = '';
  for ($y = $maxY; $y >= $minY; $y--) {
    $out .= '<option value="'.$y.'">'.$y.'</option>';
  }
  return $out;
}
$yearOptions = year_options($minY, $maxY);

/* ----- crear modelo ----- */
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $marca_id = (int)($_POST['marca_id'] ?? 0);
  $nombre   = trim($_POST['nombre'] ?? '');
  $anio     = isset($_POST['anio']) ? (int)$_POST['anio'] : 0;

  if ($marca_id > 0 && $nombre !== '' && $anio >= $minY && $anio <= $maxY) {
    $stmt = $conn->prepare("INSERT INTO modelos(marca_id, nombre, anio) VALUES (?,?,?)");
    $stmt->bind_param("isi", $marca_id, $nombre, $anio);
    $stmt->execute();
  }
  header("Location: modelos.php"); exit;
}

/* ----- borrar modelo ----- */
if (isset($_GET['del'])) {
  $id = (int)$_GET['del'];
  $conn->query("DELETE FROM modelos WHERE id=".$id);
  header("Location: modelos.php"); exit;
}

/* ----- datos para UI ----- */
$marcas = $conn->query("SELECT * FROM marcas ORDER BY nombre ASC");
$modelos = $conn->query("
  SELECT m.id, m.nombre, m.anio, mk.nombre AS marca
  FROM modelos m
  JOIN marcas mk ON mk.id = m.marca_id
  ORDER BY mk.nombre, m.nombre, m.anio DESC
");
?>
<div class="container-fluid px-2 px-lg-3">
  <h1 class="mb-4"><i class="fa fa-car"></i> Modelos</h1>

  <div class="card shadow-sm mb-3">
    <div class="card-body">
      <form method="POST" class="row g-2 align-items-end">
        <div class="col-12 col-md-4">
          <label class="form-label">Marca</label>
          <select name="marca_id" class="form-select" required>
            <option value="">Seleccione marca...</option>
            <?php while($mk=$marcas->fetch_assoc()): ?>
              <option value="<?= $mk['id'] ?>"><?= htmlspecialchars($mk['nombre']) ?></option>
            <?php endwhile; ?>
          </select>
        </div>
        <div class="col-12 col-md-5">
          <label class="form-label">Modelo</label>
          <input class="form-control" name="nombre" placeholder="Nuevo modelo (p.ej. Corolla)" required>
        </div>
        <div class="col-6 col-md-2">
          <label class="form-label">Anio</label>
          <select name="anio" class="form-select" required>
            <?= $yearOptions ?>
          </select>
        </div>
        <div class="col-6 col-md-1">
          <button class="btn btn-success w-100"><i class="fa fa-plus"></i> Agregar</button>
        </div>
      </form>
    </div>
  </div>

  <div class="card shadow-sm">
    <div class="card-body table-responsive">
      <table class="table align-middle">
        <thead>
          <tr>
            <th>ID</th>
            <th>Marca</th>
            <th>Modelo</th>
            <th>Anio</th>
            <th class="text-end">Acciones</th>
          </tr>
        </thead>
        <tbody>
        <?php while($m=$modelos->fetch_assoc()): ?>
          <tr>
            <td><?= $m['id'] ?></td>
            <td><?= htmlspecialchars($m['marca']) ?></td>
            <td><?= htmlspecialchars($m['nombre']) ?></td>
            <td><?= (int)$m['anio'] ?></td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-danger"
                 href="?del=<?= $m['id'] ?>"
                 onclick="return confirm('Eliminar modelo? Tambien se borraran compatibilidades.');">
                <i class="fa fa-trash"></i>
              </a>
            </td>
          </tr>
        <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php include 'footer.php'; ?>
