<?php
include 'header.php';
include '../db.php';

/* insertar producto */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $categoria_id       = (int)($_POST['categoria_id'] ?? 0);
  $nombre             = trim($_POST['nombre'] ?? '');
  $descripcion        = trim($_POST['descripcion'] ?? '');
  $info_adicional     = trim($_POST['info_adicional'] ?? '');
  $precio_sin_bateria = ($_POST['precio_sin_bateria'] !== '' ? (float)$_POST['precio_sin_bateria'] : 0);
  $precio_con_bateria = ($_POST['precio_con_bateria'] !== '' ? (float)$_POST['precio_con_bateria'] : 0);
  $capacidad          = trim($_POST['capacidad'] ?? '');
  $cca                = trim($_POST['cca'] ?? '');

  $imagen = '';
  if (!empty($_FILES['imagen']['name'])) {
    $destDir = "../uploads/";
    if (!is_dir($destDir)) { @mkdir($destDir, 0775, true); }
    $base   = preg_replace('/[^A-Za-z0-9._-]/', '_', $_FILES['imagen']['name']);
    $imagen = time() . '_' . $base;
    @move_uploaded_file($_FILES['imagen']['tmp_name'], $destDir . $imagen);
  }

  $sql = "INSERT INTO productos
          (categoria_id, nombre, descripcion, info_adicional,
           precio_sin_bateria, precio_con_bateria, capacidad, cca, imagen)
          VALUES (?,?,?,?,?,?,?,?,?)";
  $stmt = $conn->prepare($sql);
  $stmt->bind_param("isssddsss",
    $categoria_id, $nombre, $descripcion, $info_adicional,
    $precio_sin_bateria, $precio_con_bateria, $capacidad, $cca, $imagen
  );
  $stmt->execute();
  $producto_id = $conn->insert_id;

  $comp_modelos = $_POST['comp_modelo_id'] ?? [];
  if (!empty($comp_modelos) && $producto_id) {
    $sel = $conn->prepare("SELECT anio FROM modelos WHERE id=?");
    $ins = $conn->prepare("
      INSERT INTO producto_modelo (producto_id, modelo_id, anio_desde, anio_hasta)
      VALUES (?,?,?,NULL)
    ");
    foreach ($comp_modelos as $mid) {
      $mid = (int)$mid;
      if (!$mid) continue;
      $sel->bind_param("i", $mid);
      $sel->execute();
      if ($row = $sel->get_result()->fetch_assoc()) {
        $anio = (int)$row['anio'];
        $ins->bind_param("iii", $producto_id, $mid, $anio);
        $ins->execute();
      }
    }
  }

  header("Location: productos.php"); exit;
}

/* datos para selects */
$cats = [];
$r = $conn->query("SELECT id, nombre FROM categorias ORDER BY nombre ASC");
while($x = $r->fetch_assoc()) $cats[] = $x;

$marcas = [];
$r = $conn->query("SELECT id, nombre FROM marcas ORDER BY nombre ASC");
while($x = $r->fetch_assoc()) $marcas[] = $x;

/* mapa modelos por marca */
$map = []; // [marca_id] => [{id,label}]
$r = $conn->query("SELECT id, marca_id, nombre, anio FROM modelos ORDER BY nombre, anio DESC");
while ($m = $r->fetch_assoc()) {
  $map[(int)$m['marca_id']][] = ['id'=>(int)$m['id'], 'label'=>trim($m['nombre'].' '.$m['anio'])];
}
?>
<div class="container my-4 my-lg-5">
  <div class="row justify-content-center">
    <div class="col-12 col-lg-8 col-xxl-7">
      <h1 class="mb-4 text-center"><i class="fa fa-plus-circle"></i> Nuevo producto</h1>

      <div class="card shadow border-0">
        <div class="card-body p-4">
          <form method="POST" enctype="multipart/form-data" class="row g-3">
            <div class="col-12 col-md-6">
              <label class="form-label">Categoria</label>
              <select name="categoria_id" class="form-select" required>
                <?php foreach($cats as $c): ?>
                  <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['nombre']) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">Nombre</label>
              <input type="text" name="nombre" class="form-control" placeholder="Ej: Rocket NS60L" required>
            </div>

            <div class="col-12">
              <label class="form-label">Descripcion</label>
              <textarea name="descripcion" class="form-control" rows="3" placeholder="Caracteristicas, uso, etc."></textarea>
            </div>

            <div class="col-12">
              <label class="form-label">Informacion adicional</label>
              <textarea name="info_adicional" class="form-control" rows="3" placeholder="Garantia, notas, recomendaciones..."></textarea>
            </div>

            <div class="col-12 col-md-6">
              <label class="form-label">Precio SIN bateria (S/)</label>
              <input type="number" step="0.01" name="precio_sin_bateria" class="form-control" placeholder="Ej: 250.00">
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">Precio CON bateria (S/)</label>
              <input type="number" step="0.01" name="precio_con_bateria" class="form-control" placeholder="Ej: 350.00">
            </div>

            <div class="col-12 col-md-6">
              <label class="form-label">Capacidad (Ah)</label>
              <input type="text" name="capacidad" class="form-control" placeholder="Ej: 45Ah">
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">CCA</label>
              <input type="text" name="cca" class="form-control" placeholder="Ej: 430CCA">
            </div>

            <div class="col-12">
              <label class="form-label">Imagen</label>
              <input type="file" name="imagen" class="form-control">
            </div>

            <div class="col-12">
              <div class="card border-0 shadow-sm">
                <div class="card-body">
                  <div class="d-flex justify-content-between align-items-center mb-2">
                    <h5 class="mb-0"><i class="fa fa-link"></i> Compatibilidades (Marca / Modelo + anio)</h5>
                    <button type="button" class="btn btn-sm btn-outline-primary" id="addCompat">
                      <i class="fa fa-plus"></i> Agregar
                    </button>
                  </div>

                  <div id="compatList" class="row g-2">
                    <div class="compat-item row g-2 align-items-end">
                      <div class="col-12 col-md-6">
                        <label class="form-label">Marca</label>
                        <select class="form-select comp-marca">
                          <option value="">Seleccione...</option>
                          <?php foreach($marcas as $mk): ?>
                            <option value="<?= $mk['id'] ?>"><?= htmlspecialchars($mk['nombre']) ?></option>
                          <?php endforeach; ?>
                        </select>
                      </div>
                      <div class="col-12 col-md-6">
                        <label class="form-label">Modelo (incluye anio)</label>
                        <select name="comp_modelo_id[]" class="form-select comp-modelo" required>
                          <option value="">Seleccione una marca</option>
                        </select>
                      </div>
                    </div>
                  </div>

                  <small class="text-muted">Puedes agregar varias lineas de compatibilidad.</small>
                </div>
              </div>
            </div>

            <div class="col-12 text-end">
              <a href="productos.php" class="btn btn-secondary"><i class="fa fa-arrow-left"></i> Volver</a>
              <button type="submit" class="btn btn-success"><i class="fa fa-save"></i> Guardar producto</button>
            </div>
          </form>
        </div>
      </div>

    </div>
  </div>
</div>

<?php
echo '<script>window.MODELOS_BY_MARCA = ' .
     json_encode($map, JSON_UNESCAPED_UNICODE) .
     ';</script>';
include 'footer.php';
?>

<script>
  function loadModelosLocal(selectMarca, selectModelo){
    const mid = selectMarca.value;
    selectModelo.innerHTML = '<option value="">Seleccione...</option>';
    if(!mid){
      selectModelo.innerHTML = '<option value="">Seleccione una marca</option>';
      return;
    }
    const lista = (window.MODELOS_BY_MARCA && window.MODELOS_BY_MARCA[mid]) ? window.MODELOS_BY_MARCA[mid] : [];
    if (!lista.length) { selectModelo.innerHTML = '<option value="">Sin resultados</option>'; return; }
    const frag = document.createDocumentFragment();
    lista.forEach(m => {
      const opt = document.createElement('option');
      opt.value = m.id;
      opt.textContent = m.label;
      frag.appendChild(opt);
    });
    selectModelo.appendChild(frag);
  }

  document.addEventListener('change', (e)=>{
    if(e.target.classList.contains('comp-marca')){
      const wrap = e.target.closest('.compat-item');
      loadModelosLocal(e.target, wrap.querySelector('.comp-modelo'));
    }
  });

  document.getElementById('addCompat').addEventListener('click', ()=>{
    const list  = document.getElementById('compatList');
    const base  = list.querySelector('.compat-item');
    const clone = base.cloneNode(true);

    clone.querySelector('.comp-marca').selectedIndex = 0;
    clone.querySelector('.comp-modelo').innerHTML = '<option value="">Seleccione una marca</option>';

    if(!clone.querySelector('.btn-remove')){
      const col = document.createElement('div');
      col.className = 'col-12 text-end';
      col.innerHTML = '<button type="button" class="btn btn-sm btn-outline-danger btn-remove"><i class="fa fa-trash"></i> Quitar</button>';
      clone.appendChild(col);
    }

    list.appendChild(clone);
  });

  document.addEventListener('click', (e)=>{
    if(e.target.closest('.btn-remove')){
      const item = e.target.closest('.compat-item');
      const list = document.getElementById('compatList');
      if(list.querySelectorAll('.compat-item').length > 1) item.remove();
    }
  });
</script>
