<?php
require_once '../db.php';

/*
 * MIGRACION: crear una fila en `modelos` por cada año contenido en `modelo_anio`.
 * Requiere:
 *   - Tabla `modelos` con columnas: id, marca_id, nombre, anio (SMALLINT NOT NULL)
 *   - Tabla `modelo_anio`: id, modelo_id, anio_desde, anio_hasta (NULL = mismo año)
 */

// 1) asegurar columna y el indice unico
$conn->query("ALTER TABLE modelos ADD COLUMN IF NOT EXISTS anio SMALLINT NULL AFTER nombre");
$conn->query("DROP INDEX IF EXISTS uniq_marca_modelo ON modelos");
$conn->query("DROP INDEX IF EXISTS uniq_marca_modelo_anio ON modelos");
$conn->query("CREATE UNIQUE INDEX uniq_marca_modelo_anio ON modelos(marca_id, nombre, anio)");

$minY = 1980; $maxY = (int)date('Y') + 1;

// 2) tomar cada rango y expandir a años
$sql = "
  SELECT ma.id, m0.id AS modelo_base_id, m0.marca_id, m0.nombre,
         ma.anio_desde, ma.anio_hasta
  FROM modelo_anio ma
  JOIN modelos m0 ON m0.id = ma.modelo_id
";
$res = $conn->query($sql);
$ins = $conn->prepare("INSERT IGNORE INTO modelos (marca_id, nombre, anio) VALUES (?,?,?)");
$upd = $conn->prepare("UPDATE modelos SET anio=? WHERE id=?");

while ($row = $res->fetch_assoc()) {
  $desde = (int)$row['anio_desde'];
  $hasta = $row['anio_hasta'] !== null ? (int)$row['anio_hasta'] : $desde;
  if ($desde < $minY) $desde = $minY;
  if ($hasta > $maxY) $hasta = $maxY;

  for ($y = $desde; $y <= $hasta; $y++) {
    // crear (marca_id, nombre, anio) si no existe
    $ins->bind_param("isi", $row['marca_id'], $row['nombre'], $y);
    $ins->execute();
  }

  // si el modelo base no tiene anio aun, puedes asignarle uno (opcional)
  // $upd->bind_param("ii", $desde, $row['modelo_base_id']);
  // $upd->execute();
}

echo "OK: migracion completada";
// Opcional: cuando verifiques que todo esta OK, puedes eliminar la tabla de rangos:
// $conn->query("DROP TABLE modelo_anio");
