import { Shield, Truck, Clock, Award } from "lucide-react"

export function AboutSection() {
  return (
    <section id="nosotros" className="py-16 bg-white">
      <div className="container mx-auto px-4">
        <div className="text-center mb-12">
          <h2 className="text-3xl font-bold text-black mb-4">QUIÉNES SOMOS</h2>
          <p className="text-gray-600 max-w-3xl mx-auto text-lg">
            Somos una empresa especializada en la venta de baterías automotrices con más de 10 años de experiencia en el
            mercado peruano. Nos dedicamos a brindar soluciones de calidad para todo tipo de vehículos.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8 mb-12">
          <div className="text-center">
            <div className="bg-blue-600 text-white rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4">
              <Shield className="w-8 h-8" />
            </div>
            <h3 className="font-bold text-lg mb-2">Garantía</h3>
            <p className="text-gray-600">Todas nuestras baterías cuentan con garantía de fábrica</p>
          </div>

          <div className="text-center">
            <div className="bg-green-500 text-white rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4">
              <Truck className="w-8 h-8" />
            </div>
            <h3 className="font-bold text-lg mb-2">Delivery</h3>
            <p className="text-gray-600">Entrega a domicilio en Lima y provincias</p>
          </div>

          <div className="text-center">
            <div className="bg-blue-600 text-white rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4">
              <Clock className="w-8 h-8" />
            </div>
            <h3 className="font-bold text-lg mb-2">Atención 24/7</h3>
            <p className="text-gray-600">Servicio de atención al cliente las 24 horas</p>
          </div>

          <div className="text-center">
            <div className="bg-green-500 text-white rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4">
              <Award className="w-8 h-8" />
            </div>
            <h3 className="font-bold text-lg mb-2">Calidad</h3>
            <p className="text-gray-600">Solo trabajamos con las mejores marcas del mercado</p>
          </div>
        </div>

        <div className="bg-gray-100 rounded-lg p-8">
          <div className="grid md:grid-cols-2 gap-8 items-center">
            <div>
              <h3 className="text-2xl font-bold text-black mb-4">Nuestra Misión</h3>
              <p className="text-gray-700 mb-4">
                Proporcionar baterías automotrices de la más alta calidad a precios competitivos, con un servicio
                excepcional que supere las expectativas de nuestros clientes.
              </p>
              <p className="text-gray-700">
                Nos comprometemos a ser el socio confiable para todas las necesidades energéticas de tu vehículo,
                garantizando productos duraderos y un servicio personalizado.
              </p>
            </div>
            <div className="text-center">
              <div className="bg-blue-600 text-white rounded-lg p-6">
                <h4 className="text-3xl font-bold mb-2">10+</h4>
                <p className="text-blue-100">Años de experiencia</p>
              </div>
              <div className="grid grid-cols-2 gap-4 mt-4">
                <div className="bg-green-500 text-white rounded-lg p-4">
                  <h4 className="text-xl font-bold">5000+</h4>
                  <p className="text-green-100 text-sm">Clientes satisfechos</p>
                </div>
                <div className="bg-black text-white rounded-lg p-4">
                  <h4 className="text-xl font-bold">50+</h4>
                  <p className="text-gray-300 text-sm">Modelos disponibles</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
