export function Footer() {
  return (
    <footer className="bg-foreground text-background py-12">
      <div className="container mx-auto px-4">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
          {/* Logo and Company Info */}
          <div>
            <div className="bg-primary text-primary-foreground px-4 py-2 rounded-lg font-bold text-lg mb-4 inline-block">
              CAMBIA TU BATERÍA
            </div>
            <p className="text-sm text-background/80 mb-4">
              Tu tienda especializada en baterías automotrices con la mejor calidad y garantía del mercado.
            </p>
            <div className="text-sm text-background/80">
              <p>RUC: 20123456789</p>
              <p>Razón Social: Cambia Tu Batería S.A.C.</p>
            </div>
          </div>

          {/* Enlaces */}
          <div>
            <h3 className="font-semibold mb-4">Enlaces</h3>
            <ul className="space-y-2 text-sm text-background/80">
              <li>
                <a href="#inicio" className="hover:text-primary">
                  Inicio
                </a>
              </li>
              <li>
                <a href="#catalogo" className="hover:text-primary">
                  Catálogo
                </a>
              </li>
              <li>
                <a href="#como-comprar" className="hover:text-primary">
                  Cómo Comprar
                </a>
              </li>
              <li>
                <a href="#contacto" className="hover:text-primary">
                  Contacto
                </a>
              </li>
            </ul>
          </div>

          {/* Contacto */}
          <div>
            <h3 className="font-semibold mb-4">Contacto</h3>
            <div className="space-y-2 text-sm text-background/80">
              <p>📞 +51 999 888 777</p>
              <p>📧 ventas@cambiatubateria.com</p>
              <p>📍 Av. Principal 123, Lima, Perú</p>
              <p>🕒 Lun - Sáb: 8:00 AM - 6:00 PM</p>
            </div>
          </div>

          {/* Servicios */}
          <div>
            <h3 className="font-semibold mb-4">Servicios</h3>
            <ul className="space-y-2 text-sm text-background/80">
              <li>Venta de baterías</li>
              <li>Instalación gratuita</li>
              <li>Diagnóstico vehicular</li>
              <li>Garantía extendida</li>
              <li>Delivery a domicilio</li>
            </ul>
          </div>
        </div>

        <div className="border-t border-background/20 mt-8 pt-8">
          <div className="flex flex-col md:flex-row justify-between items-center">
            <p className="text-sm text-background/60">© 2024 Cambia Tu Batería. Todos los derechos reservados.</p>
            <div className="flex gap-4 mt-4 md:mt-0">
              <a href="#" className="text-sm text-background/60 hover:text-primary">
                Términos y Condiciones
              </a>
              <a href="#" className="text-sm text-background/60 hover:text-primary">
                Política de Privacidad
              </a>
            </div>
          </div>
        </div>
      </div>
    </footer>
  )
}
