"use client"

import { Button } from "@/components/ui/button"
import { CheckCircle } from "lucide-react"

export function HeroSection() {
  return (
    <section id="inicio" className="relative min-h-[600px] flex items-center bg-black">
      {/* Background Image */}
      <div
        className="absolute inset-0 bg-cover bg-center bg-no-repeat"
        style={{
          backgroundImage: `url('/mechanic-working-on-car-battery-in-professional-ga.jpg')`,
        }}
      >
        <div className="absolute inset-0 bg-black bg-opacity-40" />
      </div>

      <div className="absolute right-0 top-0 bottom-0 w-1/2">
        <div className="relative h-full">
          <div
            className="absolute inset-0 bg-gradient-to-r from-blue-600 to-blue-500"
            style={{
              clipPath: "polygon(30% 0%, 100% 0%, 100% 100%, 0% 100%)",
            }}
          />
        </div>
      </div>

      {/* Content */}
      <div className="relative container mx-auto px-4 py-20 z-10">
        <div className="max-w-xl">
          <div className="mb-6">
            <span className="bg-green-500 text-white px-4 py-2 rounded text-sm font-semibold">¡Llama Ahora!</span>
          </div>

          <h1 className="text-3xl md:text-5xl font-bold text-white mb-8 leading-tight">
            Las Mejores Baterías para tu Vehículo
          </h1>

          <div className="flex flex-col sm:flex-row gap-4">
            <Button
              size="lg"
              className="bg-green-500 hover:bg-green-600 text-white"
              onClick={() => document.getElementById("productos")?.scrollIntoView({ behavior: "smooth" })}
            >
              Ver Catálogo
            </Button>
            <Button
              size="lg"
              variant="outline"
              className="bg-white border-white text-black hover:bg-white/90 hover:text-black"
            >
              ventascambiatubateria@gmail.com
            </Button>
          </div>
        </div>
      </div>

      <div className="absolute right-20 top-1/2 transform -translate-y-1/2 hidden lg:block z-20">
        <div className="bg-white text-blue-600 p-6 rounded-full shadow-lg">
          <CheckCircle className="w-12 h-12" />
        </div>
        <p className="text-white text-center mt-4 font-semibold">DIAGNÓSTICO</p>
      </div>
    </section>
  )
}
