/* Render de “Nuestras Marcas” con 6 imágenes fijas */
(function () {
  // 6 marcas (usa exactamente los nombres de archivo que tienes)
  const BRANDS6 = [
    { key: 'bosch',  img: 'images/marcasbateria/bosch.png',  alt: 'Bosch'  },
    { key: 'varta',  img: 'images/marcasbateria/varta.png',  alt: 'VARTA'  },
    { key: 'record', img: 'images/marcasbateria/record.jpg', alt: 'Record' },
    { key: 'rocket', img: 'images/marcasbateria/rocket.jpg', alt: 'Rocket' },
    { key: 'solite', img: 'images/marcasbateria/solite.jpg', alt: 'Solite' },
    { key: 'exide',  img: 'images/marcasbateria/Exide.png', alt: 'Exide'  },
  ];

  function renderBrands() {
    // Pinta en #productsBrandsGrid (sección “Nuestras Marcas”)
    // o en #brandsGrid (por si usas otro id)
    const wrap = document.getElementById('productsBrandsGrid') || document.getElementById('brandsGrid');
    if (!wrap) return;

    wrap.innerHTML = BRANDS6.map(b => `
      <a href="productos.html?brand=${encodeURIComponent(b.key)}"
         class="block bg-white border rounded-xl overflow-hidden shadow-sm hover:shadow-md transition">
        <div class="aspect-square grid place-items-center p-4">
          <img src="${b.img}" alt="${b.alt}" loading="lazy"
               class="max-w-[85%] max-h-[85%] object-contain">
        </div>
      </a>
    `).join('');
  }

  // Pinta cuando las secciones ya fueron inyectadas
  document.addEventListener('sections:loaded', renderBrands);

  // Por si cargan directamente el HTML sin loader (fallback)
  if (document.readyState !== 'loading') renderBrands();
  else document.addEventListener('DOMContentLoaded', renderBrands);
})();
