(async function injectSections(){
  const app = document.getElementById('app');
  if(!app) return;
  const list = (app.getAttribute('data-include') || '').split(',').map(s=>s.trim()).filter(Boolean);

  const htmls = await Promise.all(list.map(async (path)=>{
    try{
      const res = await fetch(path, {cache:'no-store'});
      if(!res.ok) throw new Error(path + ' ' + res.status);
      return await res.text();
    }catch(e){
      console.error('Error cargando', path, e);
      return `<!-- Error cargando ${path} -->`;
    }
  }));

  app.innerHTML = htmls.join('\n');

  // Indica que ya se cargaron las secciones
  document.dispatchEvent(new CustomEvent('sections:loaded'));
})();
