(function(){
  const PEN = (n)=> `S/ ${Number(n).toLocaleString('es-PE')}`;

  function q(name){
    return new URLSearchParams(location.search).get(name);
  }

  function renderProducts(){
    const grid = document.getElementById('allProductsGrid');
    const title = document.getElementById('productsPageTitle');
    if(!grid || !window.PRODUCTS) return;

    const brand = q('brand');
    let data = window.PRODUCTS.slice();

    if(brand){
      data = data.filter(p=>p.brand === brand);
      const found = (window.BRANDS||[]).find(b=>b.key===brand);
      if(found) title.textContent = `Productos — ${found.name}`;
      else title.textContent = 'Productos';
    }else{
      title.textContent = 'Todos los productos';
    }

    grid.innerHTML = data.map(p=>`
      <div class="product-card rounded-xl overflow-hidden shadow-lg bg-white">
        <div class="h-44 bg-white grid place-items-center">
          <img src="${p.image}" alt="${p.name}" class="max-h-40 object-contain p-4" loading="lazy">
        </div>
        <div class="p-5">
          <h3 class="text-base font-bold mb-2 text-gray-800 line-clamp-2">${p.name}</h3>
          <p class="text-sm text-gray-500 mb-4 line-clamp-2">${p.short || ''}</p>
          <div class="flex items-center justify-between">
            <span class="text-xl font-extrabold text-red-600">${PEN(p.price)}</span>
            <button class="add-to-cart-btn bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg" data-product-id="${p.id}">
              Agregar
            </button>
          </div>
        </div>
      </div>
    `).join('');

    // Hook "Agregar" al carrito si usas el carrito de main.js
    const addBtns = grid.querySelectorAll('.add-to-cart-btn');
    addBtns.forEach(btn=>{
      btn.addEventListener('click',(e)=>{
        e.stopPropagation();
        const id = parseInt(btn.dataset.productId,10);
        if(window.cart && typeof window.cart.addToCart === 'function'){
          window.cart.addToCart(id,1);
        }else{
          alert('Carrito no disponible en esta página.');
        }
      });
    });
  }

  if (document.readyState !== 'loading') renderProducts();
  else document.addEventListener('DOMContentLoaded', renderProducts);
})();
